/*
 * Decompiled with CFR 0.152.
 */
package dburse.utilities;

import com.ibm.etools.iseries.subsystems.qsys.objects.QSYSObjectSubSystem;
import com.ibm.etools.iseries.subsystems.qsys.objects.QSYSRemoteDDMFile;
import com.ibm.etools.iseries.subsystems.qsys.objects.QSYSRemoteDataFile;
import com.ibm.etools.iseries.subsystems.qsys.objects.QSYSRemoteLogicalFile;
import com.ibm.etools.iseries.subsystems.qsys.objects.QSYSRemoteMember;
import com.ibm.etools.iseries.subsystems.qsys.objects.QSYSRemoteObject;
import com.ibm.etools.iseries.subsystems.qsys.objects.QSYSRemoteSourceMember;
import com.ibm.etools.iseries.subsystems.qsys.objects.RemoteObjectContext;
import dburse.utilities.BrowserParameters;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.internal.browser.WebBrowserPreference;
import org.eclipse.ui.internal.browser.WorkbenchBrowserSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginFileManager {
    private BrowserParameters browserParameters;
    private static Logger logger;
    private static PluginFileManager pluginFileManager;
    private Vector<BrowserParameters> browserParametersList = new Vector();

    private PluginFileManager() {
    }

    public static synchronized PluginFileManager getInstance() {
        if (pluginFileManager == null) {
            pluginFileManager = new PluginFileManager();
        }
        return pluginFileManager;
    }

    public void setBrowserParameters(RemoteObjectContext remoteObjectContext, String objectType, String library, String file, String member) {
        QSYSObjectSubSystem subSystem = remoteObjectContext.getObjectSubsystem();
        String as400Location = subSystem.getHostName();
        String connectionName = subSystem.getHostAliasName();
        String userId = subSystem.getUserId();
        logger.debug((Object)"----------------------------------------------");
        logger.debug((Object)objectType);
        logger.debug((Object)("member          " + member));
        logger.debug((Object)("file            " + file));
        logger.debug((Object)("library         " + library));
        logger.debug((Object)("as400 location  " + as400Location));
        logger.debug((Object)("connection name " + connectionName));
        logger.debug((Object)("userId          " + userId));
        logger.debug((Object)"----------------------------------------------");
        this.browserParameters = new BrowserParameters(connectionName, as400Location, userId, objectType, library, file, member);
        this.browserParametersList.add(this.browserParameters);
    }

    public void runSelectedDataFile(QSYSRemoteDataFile selectedFile) {
        String member = "*FIRST";
        String file = selectedFile.getName();
        String library = selectedFile.getLibrary();
        RemoteObjectContext remoteObjectContext = (RemoteObjectContext)selectedFile.getRemoteObjectContext();
        this.setBrowserParameters(remoteObjectContext, "*FILE", library, file, member);
    }

    public void runSelectedLogicalFile(QSYSRemoteLogicalFile selectedFile) {
        String member = "*FIRST";
        String file = selectedFile.getName();
        String library = selectedFile.getLibrary();
        RemoteObjectContext remoteObjectContext = (RemoteObjectContext)selectedFile.getRemoteObjectContext();
        this.setBrowserParameters(remoteObjectContext, "*FILE", library, file, member);
    }

    public void runSelectedDDMFile(QSYSRemoteDDMFile selectedFile) {
        String member = "*FIRST";
        String file = selectedFile.getName();
        String library = selectedFile.getLibrary();
        RemoteObjectContext remoteObjectContext = (RemoteObjectContext)selectedFile.getRemoteObjectContext();
        this.setBrowserParameters(remoteObjectContext, "*FILE", library, file, member);
    }

    public void runSelectedObject(QSYSRemoteObject selectedFile, String objectType) {
        String member = "*FIRST";
        String file = selectedFile.getName();
        String library = selectedFile.getLibrary();
        RemoteObjectContext remoteObjectContext = (RemoteObjectContext)selectedFile.getRemoteObjectContext();
        this.setBrowserParameters(remoteObjectContext, objectType, library, file, member);
    }

    public void runSelectedRemoteSourceMember(QSYSRemoteSourceMember selectedFile) {
        String member = selectedFile.getName();
        String file = selectedFile.getFile();
        String library = "*LIBL";
        String type = "*FILE";
        RemoteObjectContext remoteObjectContext = (RemoteObjectContext)selectedFile.getRemoteObjectContext();
        this.setBrowserParameters(remoteObjectContext, type, library, file, member);
    }

    public void runSelectedRemoteDataMember(QSYSRemoteMember selectedFile) {
        String member = selectedFile.getName();
        String file = selectedFile.getFile();
        String library = selectedFile.getLibrary();
        RemoteObjectContext remoteObjectContext = (RemoteObjectContext)selectedFile.getRemoteObjectContext();
        this.setBrowserParameters(remoteObjectContext, "*FILEP", library, file, member);
    }

    protected Shell getShell() {
        return SystemBasePlugin.getActiveWorkbenchShell();
    }

    public BrowserParameters getBrowserParameters() {
        return this.browserParameters;
    }

    public void initializeLogger() {
        logger = Logger.getLogger((String)PluginFileManager.class.getName());
    }

    public Vector<BrowserParameters> getBrowserParametersList() {
        return this.browserParametersList;
    }

    public String getDbuRdiProperty(String propertyName) {
        String propertyValue = "";
        String dbuRdiClientPath = "C:" + File.separatorChar + "ProData" + File.separatorChar + "DBU RDi Client";
        try {
            String dbuRdiPropFilePath = String.valueOf(dbuRdiClientPath) + File.separatorChar + "rdi.properties";
            File dbuRdiPropFile = new File(dbuRdiPropFilePath);
            if (dbuRdiPropFile.exists() && dbuRdiPropFile.canRead()) {
                Properties properties = new Properties();
                properties.load(new FileInputStream(dbuRdiPropFile));
                propertyValue = properties.getProperty(propertyName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        logger.debug((Object)(String.valueOf(propertyName) + ": " + propertyValue));
        return propertyValue;
    }

    public String getServerLocation() {
        String serverLocation = this.getDbuRdiProperty("server");
        if (serverLocation == null) {
            serverLocation = "localhost";
        }
        logger.debug((Object)("server location: " + serverLocation));
        return serverLocation;
    }

    public String getAjaxTimeout() {
        String timeout = this.getDbuRdiProperty("ajax_timeout");
        if (timeout == null) {
            timeout = "";
        }
        logger.debug((Object)("ajax timeout: " + timeout));
        return timeout;
    }

    public boolean isValidServerLocation(String serverLocation) {
        if (serverLocation != null && serverLocation.trim().length() > 0 && !serverLocation.matches(".*\\s+.*")) {
            return true;
        }
        logger.debug((Object)("invalid server location " + serverLocation));
        return false;
    }

    public String getOutputFromUrl(String urlStr) {
        String output = "";
        try {
            URL urlTemp = new URL(urlStr);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(urlTemp.openStream(), "UTF-8"));
            String line = "";
            while ((line = bufferedReader.readLine()) != null) {
                output = String.valueOf(output) + line;
            }
        }
        catch (MalformedURLException mfe) {
            logger.error((Object)mfe.getMessage());
        }
        catch (IOException ioe) {
            logger.error((Object)ioe.getMessage());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        logger.debug((Object)("output from URL " + urlStr + "  " + output));
        return output;
    }

    private String getFeatureVersion() {
        String version = (String)Platform.getBundle((String)"com.prodata.dbuwebplugin.rse.menu").getHeaders().get("Bundle-Version");
        return version.replaceAll("(\\d+\\.\\d+\\.\\d+).*", "$1");
    }

    private boolean getSaveNewServerLocation(String serverLocation, String reason) {
        File dbuRdiPropFile = new File("C:" + File.separatorChar + "ProData" + File.separatorChar + "DBU RDi Client" + File.separatorChar + "rdi.properties");
        if (reason.equals("new_version") && dbuRdiPropFile.exists()) {
            try {
                serverLocation = this.getDbuRdiProperty("server");
                PrintStream fileStream = new PrintStream(dbuRdiPropFile);
                fileStream.println("[ProData]");
                fileStream.println("server=" + serverLocation);
                fileStream.println("version=" + this.getFeatureVersion());
                fileStream.close();
                return true;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                logger.error((Object)("Error copying resource file: " + e.getMessage() + " " + e.getLocalizedMessage()));
            }
        } else {
            InputDialog dialog;
            String message = "Enter the name or IP of the machine running DBU RDi Server:";
            if (reason.equals("invalid_server")) {
                message = "The provided DBU RDi Server name or IP is not valid (" + this.getDbuRdiProperty("server") + "). Please try again:";
            }
            if ((dialog = new InputDialog(this.getShell(), "Set DBU RDi Server name or IP", message, "", null)).open() == 0) {
                serverLocation = dialog.getValue();
                if (!this.isValidServerLocation(serverLocation)) {
                    return this.getSaveNewServerLocation(serverLocation, "invalid_server");
                }
                try {
                    PrintStream fileStream = new PrintStream(dbuRdiPropFile);
                    fileStream.println("[ProData]");
                    fileStream.println("server=" + serverLocation);
                    fileStream.println("version=" + this.getFeatureVersion());
                    fileStream.close();
                    return true;
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    logger.error((Object)("Error copying resource file: " + e.getMessage() + " " + e.getLocalizedMessage()));
                }
            }
        }
        return false;
    }

    private void copyFile(InputStream source, Path dest) {
        try {
            if (dest.toFile().exists()) {
                Files.delete(dest);
            }
            Files.copy(source, dest, new CopyOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error((Object)("Error copying resource file: " + e.getMessage() + " " + e.getLocalizedMessage()));
        }
    }

    private boolean copyHelpFiles(String dbuRdiClientHelpPath) {
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            InputStream sourceFile = classLoader.getResourceAsStream("resources/help/index.html");
            Path destPath = Paths.get(String.valueOf(dbuRdiClientHelpPath) + File.separatorChar + "index.html", new String[0]);
            this.copyFile(sourceFile, destPath);
            sourceFile = classLoader.getResourceAsStream("resources/help/main.css");
            destPath = Paths.get(String.valueOf(dbuRdiClientHelpPath) + File.separatorChar + "main.css", new String[0]);
            this.copyFile(sourceFile, destPath);
            sourceFile = classLoader.getResourceAsStream("resources/help/DBURDi-UserManual.pdf");
            destPath = Paths.get(String.valueOf(dbuRdiClientHelpPath) + File.separatorChar + "DBURDi-UserManual.pdf", new String[0]);
            this.copyFile(sourceFile, destPath);
            sourceFile = classLoader.getResourceAsStream("resources/help/warning.png");
            destPath = Paths.get(String.valueOf(dbuRdiClientHelpPath) + File.separatorChar + "warning.png", new String[0]);
            this.copyFile(sourceFile, destPath);
            sourceFile = classLoader.getResourceAsStream("resources/help/dbu.png");
            destPath = Paths.get(String.valueOf(dbuRdiClientHelpPath) + File.separatorChar + "dbu.png", new String[0]);
            this.copyFile(sourceFile, destPath);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean dbuRdiResourcesUnpacked() {
        boolean newVersion;
        File dbuRdiHelpDir;
        String dbuRdiClientHelpPath;
        block8: {
            File dbuRdiPropFile;
            block7: {
                block6: {
                    String dbuRdiClientPath = "C:" + File.separatorChar + "ProData" + File.separatorChar + "DBU RDi Client";
                    String dbuRdiPropPath = String.valueOf(dbuRdiClientPath) + File.separatorChar + "rdi.properties";
                    dbuRdiPropFile = new File(dbuRdiPropPath);
                    dbuRdiClientHelpPath = String.valueOf(dbuRdiClientPath) + File.separatorChar + "help";
                    dbuRdiHelpDir = new File(dbuRdiClientHelpPath);
                    newVersion = dbuRdiPropFile.exists() ? !this.getDbuRdiProperty("version").equals(this.getFeatureVersion()) : true;
                    if (dbuRdiHelpDir.exists() || dbuRdiHelpDir.mkdirs()) break block6;
                    MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)("Could not create DBU RDi Client directory: C:" + File.separatorChar + "ProData" + File.separatorChar + "DBU RDi Client. Please adjust permissions or create this directory manually."));
                    return false;
                }
                if (!newVersion || this.getSaveNewServerLocation("", "new_version")) break block7;
                return false;
            }
            if (!dbuRdiPropFile.exists() || this.isValidServerLocation(this.getDbuRdiProperty("server")) || this.getSaveNewServerLocation(this.getDbuRdiProperty("server"), "invalid_server")) break block8;
            return false;
        }
        try {
            if ((newVersion || dbuRdiHelpDir.listFiles().length == 0) && !this.copyHelpFiles(dbuRdiClientHelpPath)) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)("Resources error: " + e.getMessage() + " " + e.getLocalizedMessage()));
        }
        return true;
    }

    public boolean testServerConnection(String file, String member, String targetUrl, String userName) {
        String serverLocation = this.getServerLocation();
        String testConnUrl = "http://" + serverLocation + ":" + this.getTomcatPort() + "/DBU/testConn/";
        MessageDialog dialog = this.getCustomMessageDialog("Checking DBU RDi Server connection (" + serverLocation + "). Please wait...\n\n" + "(This may take up to 60 seconds)");
        if (targetUrl != null && targetUrl.contains("quickLaunch")) {
            testConnUrl = String.valueOf(testConnUrl) + "?quickLaunch=true";
        } else if (userName != null && userName.trim().length() > 0) {
            testConnUrl = String.valueOf(testConnUrl) + "?userName=" + userName;
        }
        String testConn = this.getOutputFromUrl(testConnUrl);
        logger.debug((Object)("Test connection: " + testConn));
        IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
        if (testConn.equals("")) {
            testConnUrl = "http://" + serverLocation + ":" + this.getTomcatPort() + "/DBU/?userName=" + userName + "&connTest=true";
            testConn = this.getOutputFromUrl(testConnUrl);
        }
        if (testConn.equals("") || !testConn.equals("CONNECTED") && !testConn.contains("v")) {
            dialog.close();
            if (testConn.equals("PROCESSING")) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Another file is currently being processed. Please wait for the previous file to finish loading and try again.");
            } else if (testConn.equals("NOUSER")) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)("User " + userName + " not found. Please try again."));
            } else {
                dialog = new MessageDialog(null, "Verify DBU RDi Server name or IP", null, "Could not connect to the DBU RDi Server.\n\nIs the following server name or IP correct?\n\n'" + serverLocation + "'", 3, new String[]{"Yes", "No"}, 0);
                if (dialog.open() == 1) {
                    if (this.getSaveNewServerLocation(serverLocation, "connection_failed")) {
                        dialog.close();
                        this.loadBrowser(file, member, targetUrl);
                    } else {
                        MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Could not update DBU RDi Server location.\n\nPlease try again or contact ProData Tech Support for assistance: 800-228-6318");
                    }
                } else {
                    String helpFileURL = "file:///C:/ProData/DBU RDi Client/help/index.html#ip=" + serverLocation;
                    int style = 40;
                    try {
                        IWebBrowser browser = browserSupport.createBrowser(style, null, "DBU RDi - Server Connection Error", null);
                        browser.openURL(new URL(helpFileURL));
                    }
                    catch (Exception e) {
                        MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Could not connect to DBU RDi Server.\n\nPlease try again or contact ProData Tech Support for assistance: 800-228-6318");
                        e.printStackTrace();
                    }
                    logger.debug((Object)"Web Server is down.");
                }
                dialog.close();
            }
            dialog.close();
            return false;
        }
        if (testConn.equals("CONNECTED")) {
            dialog.close();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)("The version of DBU RDi Server on " + serverLocation + " is outdated" + " and must be updated to work with the this version of the DBU RDi Plugin.\n\n" + "To update DBU RDi Server on IBM i:\n\n\t Run the DBURDIPTF command from the i on which DBU is installed,\n\tor download the latest version of DBU" + " and update manually.\n\t(www.dodbu.com/download.shtml).\n\n" + "To update DBU RDi Server on Windows:\n\n\tContact ProData Tech Support for assistance: 800-228-6318"));
            return false;
        }
        dialog.close();
        return true;
    }

    public void loadBrowser(String file, String member) {
        this.loadBrowser(file, member, null);
    }

    public void loadBrowser(String file, String member, String targetUrl) {
        try {
            String pluginUrl;
            if (WebBrowserPreference.getBrowserChoice() == 1) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Action not allowed - attempting to launch DBU RDi in an external browser.\n\nPlease go to Window > Preferences > General > Web Browser and make sure 'Use internal web browser' is selected, then try again.\n\nIf you would like to access DBU in a browser outside of RDi, please call ProData Customer Support and ask about DBU Web: 800-228-6318");
                return;
            }
            String userName = "";
            if (targetUrl != null && targetUrl.contains("quickLaunch")) {
                pluginUrl = "http://" + this.getServerLocation() + ":" + this.getTomcatPort() + targetUrl;
            } else {
                if (!this.dbuRdiResourcesUnpacked()) {
                    MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"An error occurred while unpacking DBU RDi Plugin resources.\n\nPlease uninstall the plugin and try again, or contact ProData Tech Support if the issue persists: 800-228-6318");
                    logger.error((Object)"Missing rdi.properties file");
                    return;
                }
                if (!WorkbenchBrowserSupport.getInstance().isInternalWebBrowserAvailable()) {
                    MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"No internal browser detected. Please install a compatible browser on your computer and try again.");
                    return;
                }
                String connectionName = this.browserParameters.getConnectionName();
                String cleanedConnectionName = connectionName.replaceAll("[^a-zA-Z0-9.]", "");
                String serverLocation = this.getServerLocation();
                String ajaxTimeout = this.getAjaxTimeout();
                String as400Location = this.browserParameters.getAS400Location();
                String port = this.getTomcatPort();
                userName = this.browserParameters.getUserName().toLowerCase();
                logger.debug((Object)"----------------------------------------------------------------");
                logger.debug((Object)("connection name:   " + connectionName + "  cleaned: " + cleanedConnectionName));
                logger.debug((Object)("as400 location:  " + as400Location));
                logger.debug((Object)("user name:         " + userName));
                logger.debug((Object)("selected type:     " + this.browserParameters.getSelectedType()));
                logger.debug((Object)("selected library:  " + this.browserParameters.getSelectedLibrary()));
                logger.debug((Object)("selected file:     " + this.browserParameters.getSelectedFile()));
                logger.debug((Object)("selected member:   " + this.browserParameters.getSelectedMember()));
                logger.debug((Object)"----------------------------------------------------------------");
                pluginUrl = "http://" + serverLocation + ":" + port + "/DBU/" + "?userName=" + userName + "&eoSystem=" + URLEncoder.encode(cleanedConnectionName, "UTF-8") + "&eoLibrary=" + URLEncoder.encode(this.browserParameters.getSelectedLibrary(), "UTF-8") + "&eoType=" + URLEncoder.encode(this.browserParameters.getSelectedType(), "UTF-8") + "&eoFile=" + URLEncoder.encode(this.browserParameters.getSelectedFile(), "UTF-8") + "&eoMember=" + URLEncoder.encode(this.browserParameters.getSelectedMember(), "UTF-8") + "&as400Ip=" + as400Location + "&launchSource=RD";
                if (ajaxTimeout != "") {
                    pluginUrl = String.valueOf(pluginUrl) + "&ajaxTimeout=" + ajaxTimeout;
                }
                logger.debug((Object)("plugin URL " + pluginUrl + "  " + new Date()));
            }
            if (!(targetUrl != null && targetUrl.contains("quickLaunch") || this.testServerConnection(file, member, targetUrl, userName))) {
                return;
            }
            int style = 40;
            IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
            IWebBrowser browser = browserSupport.createBrowser(style, null, null, "DBU RDi");
            browser.openURL(new URL(pluginUrl));
        }
        catch (PartInitException pie) {
            logger.error((Object)pie.getMessage());
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)("PartInitException \n" + pie.getMessage()));
        }
        catch (MalformedURLException mfe) {
            logger.error((Object)mfe.getMessage());
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)mfe.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)e.getMessage());
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)e.getLocalizedMessage());
        }
    }

    private MessageDialog getCustomMessageDialog(String message) {
        MessageDialog dialog = new MessageDialog(this.getShell(), "Status", null, message, 2, new String[]{"Close"}, 0){

            protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
                return null;
            }

            protected boolean canHandleShellCloseEvent() {
                return false;
            }

            protected void setShellStyle(int arg0) {
                super.setShellStyle(32);
            }
        };
        dialog.setBlockOnOpen(false);
        dialog.open();
        return dialog;
    }

    public String getTomcatPort() {
        return "8205";
    }
}

