/*
 * Decompiled with CFR 0.152.
 */
package dburse.ui.actions;

import com.ibm.etools.iseries.subsystems.qsys.objects.QSYSRemoteDDMFile;
import com.ibm.etools.iseries.subsystems.qsys.objects.QSYSRemoteDataFile;
import com.ibm.etools.iseries.subsystems.qsys.objects.QSYSRemoteLogicalFile;
import com.ibm.etools.iseries.subsystems.qsys.objects.QSYSRemoteObject;
import dburse.utilities.BrowserParameters;
import dburse.utilities.DbuLogManager;
import dburse.utilities.PluginFileManager;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class OpenQSYSRemoteObject
implements IObjectActionDelegate {
    private List<QSYSRemoteObject> selectedFiles = new ArrayList<QSYSRemoteObject>();
    private PluginFileManager pluginFileManager;
    private static Logger logger;

    public OpenQSYSRemoteObject() {
        logger = Logger.getLogger((String)OpenQSYSRemoteObject.class.getName());
        new DbuLogManager(logger);
        this.pluginFileManager = PluginFileManager.getInstance();
        logger.debug((Object)("OpenQSYSRemoteObject.constructor " + new Date()));
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        logger.debug((Object)("logging OpenQSYSRemoteObject.setActivePart " + new Date()));
    }

    public void run(IAction action) {
        logger.debug((Object)("OpenQSYSRemoteObject.run " + new Date()));
        logger.debug((Object)"processing selected file READY STATE");
        QSYSRemoteObject selectedFile = this.getFirstSelectedRemoteFile();
        logger.debug((Object)("selected file: " + selectedFile.getName()));
        if (selectedFile != null) {
            String objectType;
            String subType;
            String type = selectedFile.getType();
            logger.debug((Object)("type: " + type + "    data file class " + selectedFile.getClass()));
            if (selectedFile instanceof QSYSRemoteDataFile) {
                subType = selectedFile.getSubType();
                logger.debug((Object)("subType: " + subType));
                if (type.equals("*FILE") && (subType.equals("PF-DTA") || subType.equals("PF38-DTA"))) {
                    this.pluginFileManager.runSelectedDataFile((QSYSRemoteDataFile)selectedFile);
                } else {
                    MessageDialog.openError((Shell)this.getShell(), (String)"Selection Error", (String)"Please an object of type '*FILE' or subtype 'PF-DTA' or 'PF38-DTA'");
                }
            } else if (selectedFile instanceof QSYSRemoteLogicalFile) {
                subType = selectedFile.getSubType();
                logger.debug((Object)("subType: " + subType));
                if (type.equals("*FILE") && (subType.equals("LF") || subType.equals("LF38"))) {
                    this.pluginFileManager.runSelectedLogicalFile((QSYSRemoteLogicalFile)selectedFile);
                } else {
                    MessageDialog.openError((Shell)this.getShell(), (String)"Selection Error", (String)"Please a *FILE object of subtype 'LF' or 'LF38");
                }
            } else if (selectedFile instanceof QSYSRemoteDDMFile) {
                subType = selectedFile.getSubType();
                logger.debug((Object)("subType: " + subType));
                if (type.equals("*FILE") && subType.equals("DDMF")) {
                    this.pluginFileManager.runSelectedDDMFile((QSYSRemoteDDMFile)selectedFile);
                } else {
                    MessageDialog.openError((Shell)this.getShell(), (String)"Selection Error", (String)"Please a *FILE object of subtype 'DDMF'");
                }
            } else if (type.equals("*DTAQ") || type.equals("*DTAARA") || type.equals("*JRN")) {
                objectType = type.equals("*DTAQ") ? "Data Queues" : (type.equals("*DTAARA") ? "Data Areas" : "Journals");
                this.pluginFileManager.runSelectedObjectFile(selectedFile, objectType);
            } else {
                try {
                    objectType = "";
                    String subType2 = selectedFile.getSubType();
                    logger.debug((Object)("type " + type + "  subType: " + subType2));
                    if (type.equals("*USRSPC")) {
                        if (subType2 != null && subType2.trim().length() > 0) {
                            if (type.equals("*USRSPC") && subType2.equals("DBUAPP1")) {
                                objectType = "Applications";
                            }
                        } else {
                            objectType = "User Spaces";
                        }
                        this.pluginFileManager.runSelectedObjectFile(selectedFile, objectType);
                    } else {
                        MessageDialog.openError((Shell)this.getShell(), (String)"Selection Error", (String)("Unsupported Object " + type));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        BrowserParameters browserParameters = this.pluginFileManager.getBrowserParameters();
        String fileName = String.valueOf(browserParameters.getSelectedFile()) + "." + selectedFile.getSubType().toLowerCase();
        this.pluginFileManager.loadBrowser(fileName);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selectedFiles.clear();
        for (Object obj : (IStructuredSelection)selection) {
            if (!(obj instanceof QSYSRemoteObject)) continue;
            this.selectedFiles.add((QSYSRemoteObject)obj);
        }
    }

    protected Shell getShell() {
        return SystemBasePlugin.getActiveWorkbenchShell();
    }

    protected QSYSRemoteObject getFirstSelectedRemoteFile() {
        if (this.selectedFiles.size() > 0) {
            return this.selectedFiles.get(0);
        }
        return null;
    }

    protected boolean canHandleShellCloseEvent() {
        return false;
    }
}

