/*
 * Decompiled with CFR 0.152.
 */
package dburse.utilities;

import com.ibm.etools.iseries.subsystems.qsys.objects.QSYSObjectSubSystem;
import com.ibm.etools.iseries.subsystems.qsys.objects.QSYSRemoteDDMFile;
import com.ibm.etools.iseries.subsystems.qsys.objects.QSYSRemoteDataFile;
import com.ibm.etools.iseries.subsystems.qsys.objects.QSYSRemoteLogicalFile;
import com.ibm.etools.iseries.subsystems.qsys.objects.QSYSRemoteMember;
import com.ibm.etools.iseries.subsystems.qsys.objects.QSYSRemoteObject;
import com.ibm.etools.iseries.subsystems.qsys.objects.RemoteObjectContext;
import dburse.utilities.BrowserParameters;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginFileManager {
    private BrowserParameters browserParameters;
    private static Logger logger;
    private static PluginFileManager pluginFileManager;
    private Vector<BrowserParameters> browserParametersList = new Vector();

    private PluginFileManager() {
    }

    public static synchronized PluginFileManager getInstance() {
        if (pluginFileManager == null) {
            pluginFileManager = new PluginFileManager();
        }
        return pluginFileManager;
    }

    public void setBrowserParameters(RemoteObjectContext remoteObjectContext, String objectType, String library, String file, String member) {
        QSYSObjectSubSystem subSystem = remoteObjectContext.getObjectSubsystem();
        String ipAddress = subSystem.getHostName();
        String connectionName = subSystem.getHostAliasName();
        String userId = subSystem.getUserId();
        String name = member.equals("*FIRST") ? file : member;
        logger.debug((Object)"----------------------------------------------");
        logger.debug((Object)objectType);
        logger.debug((Object)("name            " + name));
        logger.debug((Object)("member          " + member));
        logger.debug((Object)("file            " + file));
        logger.debug((Object)("library         " + library));
        logger.debug((Object)("ip address      " + ipAddress));
        logger.debug((Object)("connection name " + connectionName));
        logger.debug((Object)("userId          " + userId));
        logger.debug((Object)"----------------------------------------------");
        this.browserParameters = new BrowserParameters(connectionName, ipAddress, userId, objectType, library, file, member, name);
        this.browserParametersList.add(this.browserParameters);
    }

    public void runSelectedDataFile(QSYSRemoteDataFile selectedFile) {
        String member = "*FIRST";
        String file = selectedFile.getName();
        String library = selectedFile.getLibrary();
        RemoteObjectContext remoteObjectContext = (RemoteObjectContext)selectedFile.getRemoteObjectContext();
        this.setBrowserParameters(remoteObjectContext, "Physicals", library, file, member);
    }

    public void runSelectedDDMFile(QSYSRemoteDDMFile selectedFile) {
        String member = "*FIRST";
        String file = selectedFile.getName();
        String library = selectedFile.getLibrary();
        RemoteObjectContext remoteObjectContext = (RemoteObjectContext)selectedFile.getRemoteObjectContext();
        this.setBrowserParameters(remoteObjectContext, "DDM", library, file, member);
    }

    public void runSelectedLogicalFile(QSYSRemoteLogicalFile selectedFile) {
        String member = "*FIRST";
        String file = selectedFile.getName();
        String library = selectedFile.getLibrary();
        RemoteObjectContext remoteObjectContext = (RemoteObjectContext)selectedFile.getRemoteObjectContext();
        this.setBrowserParameters(remoteObjectContext, "Logicals", library, file, member);
    }

    public void runSelectedObjectFile(QSYSRemoteObject selectedFile, String objectType) {
        String member = "*FIRST";
        String file = selectedFile.getName();
        String library = selectedFile.getLibrary();
        RemoteObjectContext remoteObjectContext = (RemoteObjectContext)selectedFile.getRemoteObjectContext();
        this.setBrowserParameters(remoteObjectContext, objectType, library, file, member);
    }

    public void runSelectedRemoteDataMember(QSYSRemoteMember selectedFile) {
        String member = selectedFile.getName();
        String file = selectedFile.getFile();
        String library = selectedFile.getLibrary();
        RemoteObjectContext remoteObjectContext = (RemoteObjectContext)selectedFile.getRemoteObjectContext();
        this.setBrowserParameters(remoteObjectContext, "Physicals", library, file, member);
    }

    protected Shell getShell() {
        return SystemBasePlugin.getActiveWorkbenchShell();
    }

    public BrowserParameters getBrowserParameters() {
        return this.browserParameters;
    }

    public void initializeLogger() {
        logger = Logger.getLogger((String)PluginFileManager.class.getName());
    }

    public Vector<BrowserParameters> getBrowserParametersList() {
        return this.browserParametersList;
    }

    public String getTomcatIpAddress() {
        String ipAddress = "localhost";
        String userHome = System.getProperty("user.home");
        String userProDataDir = String.valueOf(userHome) + File.separatorChar + "ProData";
        File proDataDir = new File(userProDataDir);
        if (proDataDir.exists() && proDataDir.canRead()) {
            try {
                String pluginFileName = String.valueOf(userProDataDir) + File.separatorChar + "rdi.properties";
                File pluginFile = new File(pluginFileName);
                if (pluginFile.exists() && pluginFile.canRead()) {
                    Properties properties = new Properties();
                    properties.load(new FileInputStream(pluginFile));
                    ipAddress = properties.getProperty("ip_address");
                    if (ipAddress == null) {
                        ipAddress = "localhost";
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        logger.debug((Object)("ip address: " + ipAddress));
        return ipAddress;
    }

    public boolean isValidIpAddress(String ipAddress) {
        if (ipAddress != null && ipAddress.trim().length() > 0) {
            if (ipAddress.toLowerCase().equals("localhost")) {
                logger.debug((Object)"found localhost");
                return true;
            }
            if (ipAddress.matches("^(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$")) {
                String[] groups = ipAddress.split("\\.");
                int i = 0;
                while (i <= 3) {
                    String segment = groups[i];
                    if (segment == null || segment.length() <= 0) {
                        logger.debug((Object)"no ip address segments found");
                        return false;
                    }
                    int value = 0;
                    try {
                        value = Integer.parseInt(segment);
                    }
                    catch (NumberFormatException numberFormatException) {
                        logger.debug((Object)("number format exception for " + segment));
                        return false;
                    }
                    if (value > 255) {
                        logger.debug((Object)("segment value error: " + value));
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        }
        logger.debug((Object)("invalid ip address " + ipAddress));
        return false;
    }

    public String getOutputFromURL(String urlStr) {
        String output = "";
        try {
            URL urlTemp = new URL(urlStr);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(urlTemp.openStream(), "UTF-8"));
            String line = "";
            while ((line = bufferedReader.readLine()) != null) {
                output = String.valueOf(output) + line;
            }
        }
        catch (MalformedURLException mfe) {
            logger.error((Object)mfe.getMessage());
        }
        catch (IOException ioe) {
            logger.error((Object)ioe.getMessage());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        logger.debug((Object)("output from URL " + urlStr + "  " + output));
        return output;
    }

    public String getTomcatPort() {
        return "8081";
    }
}

