/*
 * Decompiled with CFR 0.152.
 */
package dburse.utilities;

import java.io.File;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.DailyRollingFileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.PropertyConfigurator;

public class DbuLogManager {
    public DbuLogManager(Logger logger) {
        this.initializeLogger(logger);
    }

    private void initializeLogger(Logger logger) {
        String userHome = System.getProperty("user.home");
        String userProDataDir = String.valueOf(userHome) + File.separatorChar + "ProData";
        String log4jFilePath = String.valueOf(userProDataDir) + File.separatorChar + "log4j.properties";
        File log4jTempFile = new File(log4jFilePath);
        if (log4jTempFile.exists() && log4jTempFile.canRead()) {
            PropertyConfigurator.configure((String)log4jFilePath);
        } else {
            String logFileName = String.valueOf(userProDataDir) + File.separator + "trace.log";
            ConsoleAppender consoleAppender = new ConsoleAppender();
            consoleAppender.setName("CONSOLE");
            String consolePattern = "%d{yyyy-MM-dd HH:mm:ss}-%t-%x-%-5p-%-10c:%m%n";
            consoleAppender.setLayout((Layout)new PatternLayout(consolePattern));
            consoleAppender.setThreshold((Priority)Level.DEBUG);
            consoleAppender.activateOptions();
            Logger.getRootLogger().addAppender((Appender)consoleAppender);
            DailyRollingFileAppender rollingAppender = new DailyRollingFileAppender();
            String rollingPattern = "%d{yyyy-MM-dd HH:mm:ss}-%t-%x-%-5p-%-10c:%m%n";
            rollingAppender.setLayout((Layout)new PatternLayout(rollingPattern));
            rollingAppender.setFile(logFileName);
            rollingAppender.setDatePattern("'.'yyyy-MM-dd");
            rollingAppender.activateOptions();
            Logger.getRootLogger().addAppender((Appender)rollingAppender);
            logger.debug((Object)"Log4J initialized programmatically");
        }
        logger.debug((Object)("initializeLogger " + logger.getName()));
    }
}

