/*
 * Decompiled with CFR 0.152.
 */
package dburse.ui.actions;

import com.ibm.etools.iseries.subsystems.qsys.objects.QSYSRemoteDataMember;
import com.ibm.etools.iseries.subsystems.qsys.objects.QSYSRemoteMember;
import dburse.utilities.BrowserParameters;
import dburse.utilities.DbuLogManager;
import dburse.utilities.PluginFileManager;
import java.io.File;
import java.io.FileInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.browser.WorkbenchBrowserSupport;

public class OpenQSYSRemoteMember
implements IObjectActionDelegate {
    private List<QSYSRemoteMember> selectedFiles;
    private PluginFileManager pluginFileManager;
    private String READY_STATE = "ready";
    private String PROCESSING_STATE = "processing";
    private String state = this.READY_STATE;
    private static Logger logger;

    public OpenQSYSRemoteMember() {
        this.selectedFiles = new ArrayList<QSYSRemoteMember>();
        logger = Logger.getLogger((String)OpenQSYSRemoteMember.class.getName());
        new DbuLogManager(logger);
        this.pluginFileManager = PluginFileManager.getInstance();
        logger.debug((Object)("OpenQSYSRemoteObject.constructor " + new Date()));
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        logger.debug((Object)("logging OpenQSYSRemoteObject.setActivePart " + new Date()));
    }

    public void run(IAction action) {
        logger.debug((Object)("OpenQSYSRemoteObject.run " + new Date()));
        if (this.state.equals(this.READY_STATE)) {
            logger.debug((Object)"processing selected file READY STATE");
            QSYSRemoteMember selectedFile = this.getFirstSelectedRemoteFile();
            logger.debug((Object)("selected member: " + selectedFile.getName()));
            logger.debug((Object)("selected file: " + selectedFile.getFile()));
            if (selectedFile != null) {
                String type = selectedFile.getType();
                logger.debug((Object)("type: " + type + "    data file class " + selectedFile.getClass()));
                if (selectedFile instanceof QSYSRemoteDataMember) {
                    String subType = selectedFile.getSubType();
                    logger.debug((Object)("subType: " + subType));
                    if (type.equals("MBR") && subType.equals("DTA")) {
                        this.pluginFileManager.runSelectedRemoteDataMember((QSYSRemoteMember)((QSYSRemoteDataMember)selectedFile));
                    } else {
                        MessageDialog.openError((Shell)this.getShell(), (String)"Selection Error", (String)"Please an object of type '*FILE' or subtype 'PF-DTA' or 'PF38-DTA'");
                    }
                } else {
                    MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Unknown Member Object Type");
                }
            }
            this.state = this.PROCESSING_STATE;
            BrowserParameters browserParameters = this.pluginFileManager.getBrowserParameters();
            String fileName = String.valueOf(browserParameters.getSelectedMember()) + ".mbr";
            String tabName = String.valueOf(browserParameters.getConnectionName()) + "/" + browserParameters.getSelectedLibrary() + "/" + browserParameters.getSelectedFile() + "/" + fileName;
            MessageDialog dialog = this.getCustomMessageDialog(tabName);
            this.loadBrowser(browserParameters, dialog, fileName);
        } else {
            MessageDialog.openError((Shell)this.getShell(), (String)"Processing", (String)"Processing the previous selection.");
        }
    }

    private void loadBrowser(BrowserParameters browserParameters, MessageDialog dbuDialog, String fileName) {
        long startDate = new Date().getTime();
        String tabName = "DBU-" + fileName;
        String filePath = String.valueOf(browserParameters.getConnectionName()) + "/" + browserParameters.getSelectedLibrary() + "/" + browserParameters.getSelectedFile() + "/" + fileName;
        String connectionName = browserParameters.getConnectionName();
        String cleanedConnectionName = connectionName.replaceAll("[^a-zA-Z0-9.]", "");
        String windowsUserName = System.getProperty("user.name");
        logger.debug((Object)"----------------------------------------------------------------");
        logger.debug((Object)("connection name:   " + connectionName + "  cleaned: " + cleanedConnectionName));
        logger.debug((Object)("as400 ip address:  " + browserParameters.getAS400IpAddress()));
        logger.debug((Object)("user name:         " + browserParameters.getUserName()));
        logger.debug((Object)("windows user name: " + windowsUserName));
        logger.debug((Object)("selected type:     " + browserParameters.getSelectedType()));
        logger.debug((Object)("selected library:  " + browserParameters.getSelectedLibrary()));
        logger.debug((Object)("selected file:     " + browserParameters.getSelectedFile()));
        logger.debug((Object)("selected member:   " + browserParameters.getSelectedMember()));
        logger.debug((Object)("edit object name:  " + browserParameters.getEditObjectName()));
        logger.debug((Object)"----------------------------------------------------------------");
        boolean foundUserRdiPropertiesFile = this.foundRdiPropertiesFile();
        long endDate = new Date().getTime();
        logger.debug((Object)("found the user rdi properties file: " + foundUserRdiPropertiesFile + "  " + (endDate - startDate) + "  " + new Date()));
        if (!foundUserRdiPropertiesFile) {
            String message = "Missing properties file for " + windowsUserName + ".\n\rPlease rerun the Installer for the Single User and try again.";
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)message);
            this.state = this.READY_STATE;
            logger.error((Object)("Missing rdi.properties file for " + windowsUserName));
            return;
        }
        startDate = new Date().getTime();
        String tomcatIpAddress = this.pluginFileManager.getTomcatIpAddress();
        if (!this.pluginFileManager.isValidIpAddress(tomcatIpAddress)) {
            String message = "Invalid IP Address in the properties file for " + windowsUserName + ".\n\rPlease rerun the Installer for the Single User and try again.";
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)message);
            this.state = this.READY_STATE;
            return;
        }
        String as400IpAddress = browserParameters.getAS400IpAddress();
        String userName = browserParameters.getUserName().toLowerCase();
        startDate = new Date().getTime();
        String port = this.pluginFileManager.getTomcatPort();
        try {
            String userTestURL = "http://" + tomcatIpAddress + ":" + port + "/DBU/dbuFindUser/?user=" + userName + "&systemName=" + cleanedConnectionName + "&as400ip=" + as400IpAddress;
            startDate = new Date().getTime();
            String userTestURLOutput = this.pluginFileManager.getOutputFromURL(userTestURL);
            logger.debug((Object)("after get test url output " + userTestURLOutput + "  " + (new Date().getTime() - startDate) + "  " + new Date()));
            boolean systemsXmlFileFound = false;
            if (userTestURLOutput != null && userTestURLOutput.trim().length() > 0 && !userTestURLOutput.equals("Not Found")) {
                systemsXmlFileFound = true;
            }
            boolean sessionConnectionOkay = false;
            String sessionLimitURL = "http://" + tomcatIpAddress + ":" + port + "/DBU/sessionLimit/?user=" + userName + "&systemName=" + cleanedConnectionName + "&libName=" + browserParameters.getSelectedLibrary() + "&typeName=" + browserParameters.getSelectedType() + "&eoFile=" + URLEncoder.encode(browserParameters.getSelectedFile(), "UTF-8") + "&eoMember=" + URLEncoder.encode(browserParameters.getSelectedMember(), "UTF-8") + "&eoName=" + URLEncoder.encode(browserParameters.getEditObjectName(), "UTF-8") + "&as400ip=" + as400IpAddress;
            logger.debug((Object)("session limit URL:  " + sessionLimitURL));
            startDate = new Date().getTime();
            String sessionLimitURLOutput = this.pluginFileManager.getOutputFromURL(sessionLimitURL);
            logger.debug((Object)("session limit url output " + sessionLimitURLOutput));
            if (sessionLimitURLOutput.equals("SIGNON")) {
                sessionConnectionOkay = true;
            }
            if (systemsXmlFileFound && sessionConnectionOkay) {
                String pluginURL = "http://" + tomcatIpAddress + ":" + port + "/DBU/?user=" + userName + "&systemName=" + cleanedConnectionName + "&libName=" + browserParameters.getSelectedLibrary() + "&typeName=" + browserParameters.getSelectedType() + "&eoFile=" + URLEncoder.encode(browserParameters.getSelectedFile(), "UTF-8") + "&eoMember=" + URLEncoder.encode(browserParameters.getSelectedMember(), "UTF-8") + "&eoName=" + URLEncoder.encode(browserParameters.getEditObjectName(), "UTF-8") + "&as400ip=" + as400IpAddress;
                logger.debug((Object)("plugin URL " + pluginURL + "  " + new Date()));
                String displayMode = this.getDisplayMode();
                int style = 40;
                if (displayMode.equals("debug")) {
                    style = 42;
                }
                startDate = new Date().getTime();
                String generatedId = String.valueOf(userName) + "-" + Calendar.getInstance().getTimeInMillis();
                WorkbenchBrowserSupport.getInstance().createBrowser(style, generatedId, tabName, filePath).openURL(new URL(pluginURL));
                this.state = this.READY_STATE;
                if (dbuDialog != null) {
                    try {
                        dbuDialog.close();
                    }
                    catch (Exception exception) {
                        logger.debug((Object)"Exception caught here.");
                    }
                }
            } else if (userTestURLOutput.trim().length() == 0) {
                if (dbuDialog != null) {
                    dbuDialog.close();
                }
                MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Please restart the Web Server.");
                logger.debug((Object)"Web Server is down.");
                this.state = this.READY_STATE;
            } else if (!sessionConnectionOkay && userTestURLOutput.equals("Route to Session Count")) {
                if (sessionLimitURLOutput.equals("EXCESS")) {
                    if (dbuDialog != null) {
                        dbuDialog.close();
                    }
                    String message = "Maximum number of sessions (4) exceeded for system " + connectionName + ".  Please close a tab and try again.";
                    MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)message);
                    logger.debug((Object)"Maximum Number of Sessions Exceeded");
                    this.state = this.READY_STATE;
                } else {
                    if (dbuDialog != null) {
                        dbuDialog.close();
                    }
                    String message = "Unknown Error.  " + sessionLimitURLOutput;
                    MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)message);
                    logger.debug((Object)("Unknown Error " + sessionLimitURLOutput));
                    this.state = this.READY_STATE;
                }
            } else {
                String dbuRoute = "first_user";
                if (!sessionConnectionOkay) {
                    if (!systemsXmlFileFound) {
                        logger.debug((Object)"no user file found keep dbu route at first user");
                    } else {
                        logger.debug((Object)"connection error");
                        dbuRoute = "conn_error";
                    }
                }
                if (dbuDialog != null) {
                    dbuDialog.close();
                }
                String pluginURL = "http://" + tomcatIpAddress + ":" + port + "/DBU/?user=" + userName + "&systemName=" + cleanedConnectionName + "&libName=" + browserParameters.getSelectedLibrary() + "&typeName=" + browserParameters.getSelectedType() + "&eoFile=" + URLEncoder.encode(browserParameters.getSelectedFile(), "UTF-8") + "&eoMember=" + URLEncoder.encode(browserParameters.getSelectedMember(), "UTF-8") + "&eoName=" + URLEncoder.encode(browserParameters.getEditObjectName(), "UTF-8") + "&as400ip=" + as400IpAddress + "&dbu_route=" + dbuRoute;
                logger.debug((Object)("plugin URL " + pluginURL));
                String displayMode = this.getDisplayMode();
                int style = 40;
                if (displayMode.equals("debug")) {
                    style = 42;
                }
                String generatedId = String.valueOf(userName) + "-" + Calendar.getInstance().getTimeInMillis();
                WorkbenchBrowserSupport.getInstance().createBrowser(style, generatedId, tabName, filePath).openURL(new URL(pluginURL));
                this.state = this.READY_STATE;
            }
        }
        catch (PartInitException pie) {
            if (dbuDialog != null) {
                dbuDialog.close();
            }
            logger.error((Object)pie.getMessage());
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)("PartInitException \n" + pie.getMessage()));
        }
        catch (MalformedURLException mfe) {
            if (dbuDialog != null) {
                dbuDialog.close();
            }
            logger.error((Object)mfe.getMessage());
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)mfe.getMessage());
        }
        catch (Exception e) {
            if (dbuDialog != null) {
                dbuDialog.close();
            }
            e.printStackTrace();
            logger.error((Object)e.getMessage());
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)e.getLocalizedMessage());
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selectedFiles.clear();
        for (Object obj : (IStructuredSelection)selection) {
            System.out.println("object is " + obj.getClass());
            if (!(obj instanceof QSYSRemoteMember)) continue;
            this.selectedFiles.add((QSYSRemoteMember)obj);
        }
    }

    protected Shell getShell() {
        return SystemBasePlugin.getActiveWorkbenchShell();
    }

    protected QSYSRemoteMember getFirstSelectedRemoteFile() {
        if (this.selectedFiles.size() > 0) {
            return this.selectedFiles.get(0);
        }
        return null;
    }

    private boolean foundRdiPropertiesFile() {
        String userHome = System.getProperty("user.home");
        String userProDataDir = String.valueOf(userHome) + File.separatorChar + "ProData" + File.separatorChar + "rdi.properties";
        File proDataDir = new File(userProDataDir);
        return proDataDir.exists() && proDataDir.canRead();
    }

    private String getDisplayMode() {
        String displayMode = "";
        String userHome = System.getProperty("user.home");
        String userProDataDir = String.valueOf(userHome) + File.separatorChar + "ProData";
        File proDataDir = new File(userProDataDir);
        if (proDataDir.exists() && proDataDir.canRead()) {
            try {
                String pluginFileName = String.valueOf(userProDataDir) + File.separatorChar + "rdi.properties";
                File pluginFile = new File(pluginFileName);
                if (pluginFile.exists() && pluginFile.canRead()) {
                    Properties properties = new Properties();
                    properties.load(new FileInputStream(pluginFile));
                    displayMode = properties.getProperty("display");
                    if (displayMode == null) {
                        displayMode = "";
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        logger.debug((Object)("display mode " + displayMode));
        return displayMode;
    }

    private MessageDialog getCustomMessageDialog(String tabName) {
        MessageDialog dialog = new MessageDialog(this.getShell(), "Information", null, "Loading " + tabName, 2, new String[]{"Close"}, 0){

            protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
                return null;
            }

            protected boolean canHandleShellCloseEvent() {
                return false;
            }

            protected void setShellStyle(int arg0) {
                super.setShellStyle(32);
            }
        };
        dialog.setBlockOnOpen(false);
        dialog.open();
        return dialog;
    }

    protected boolean canHandleShellCloseEvent() {
        return false;
    }
}

