/*
 * Decompiled with CFR 0.152.
 */
package dburse.ui.actions;

import com.ibm.etools.iseries.subsystems.qsys.objects.QSYSRemoteDataMember;
import com.ibm.etools.iseries.subsystems.qsys.objects.QSYSRemoteMember;
import com.ibm.etools.iseries.subsystems.qsys.objects.QSYSRemoteSourceMember;
import dburse.utilities.BrowserParameters;
import dburse.utilities.DbuLogManager;
import dburse.utilities.PluginFileManager;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class OpenQSYSRemoteMember
implements IObjectActionDelegate {
    private List<QSYSRemoteMember> selectedFiles = new ArrayList<QSYSRemoteMember>();
    private PluginFileManager pluginFileManager;
    private static Logger logger;

    public OpenQSYSRemoteMember() {
        logger = Logger.getLogger((String)OpenQSYSRemoteMember.class.getName());
        new DbuLogManager(logger);
        this.pluginFileManager = PluginFileManager.getInstance();
        logger.debug((Object)("OpenQSYSRemoteObject.constructor " + new Date()));
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        logger.debug((Object)("logging OpenQSYSRemoteObject.setActivePart " + new Date()));
    }

    public void run(IAction action) {
        logger.debug((Object)("OpenQSYSRemoteObject.run " + new Date()));
        QSYSRemoteMember selectedFile = this.getFirstSelectedRemoteFile();
        logger.debug((Object)("selected member: " + selectedFile.getName()));
        logger.debug((Object)("selected file: " + selectedFile.getFile()));
        if (selectedFile != null) {
            String subType;
            String type = selectedFile.getType();
            logger.debug((Object)("type: " + type + "    data file class " + selectedFile.getClass()));
            if (selectedFile instanceof QSYSRemoteDataMember) {
                subType = selectedFile.getSubType();
                logger.debug((Object)("subType: " + subType));
                if (type.equals("MBR") && subType.equals("DTA")) {
                    this.pluginFileManager.runSelectedRemoteDataMember((QSYSRemoteMember)((QSYSRemoteDataMember)selectedFile));
                } else {
                    MessageDialog.openError((Shell)this.getShell(), (String)"Selection Error", (String)"Please an object of type '*FILE' or subtype 'PF-DTA' or 'PF38-DTA'");
                }
            } else if (selectedFile instanceof QSYSRemoteSourceMember) {
                subType = selectedFile.getSubType();
                logger.debug((Object)("subType: " + subType));
                if ((type.equals("PF") || type.equals("LF")) && subType.equals("SRC")) {
                    this.pluginFileManager.runSelectedRemoteSourceMember((QSYSRemoteSourceMember)selectedFile);
                } else {
                    MessageDialog.openError((Shell)this.getShell(), (String)"Selection Error", (String)"Please an object of type '*FILE' or subtype 'PF-DTA' or 'PF38-DTA'");
                }
            } else {
                MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Unknown Member Object Type");
            }
        }
        BrowserParameters browserParameters = this.pluginFileManager.getBrowserParameters();
        String file = browserParameters.getSelectedFile();
        String member = browserParameters.getSelectedMember();
        this.pluginFileManager.loadBrowser(file, member);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selectedFiles.clear();
        for (Object obj : (IStructuredSelection)selection) {
            System.out.println("object is " + obj.getClass());
            if (!(obj instanceof QSYSRemoteMember)) continue;
            this.selectedFiles.add((QSYSRemoteMember)obj);
        }
    }

    protected Shell getShell() {
        return SystemBasePlugin.getActiveWorkbenchShell();
    }

    protected QSYSRemoteMember getFirstSelectedRemoteFile() {
        if (this.selectedFiles.size() > 0) {
            return this.selectedFiles.get(0);
        }
        return null;
    }

    protected boolean canHandleShellCloseEvent() {
        return false;
    }
}

