/*
 * Decompiled with CFR 0.152.
 */
package dburse.utilities;

import com.ibm.etools.iseries.subsystems.qsys.objects.QSYSObjectSubSystem;
import com.ibm.etools.iseries.subsystems.qsys.objects.QSYSRemoteDDMFile;
import com.ibm.etools.iseries.subsystems.qsys.objects.QSYSRemoteDataFile;
import com.ibm.etools.iseries.subsystems.qsys.objects.QSYSRemoteLogicalFile;
import com.ibm.etools.iseries.subsystems.qsys.objects.QSYSRemoteMember;
import com.ibm.etools.iseries.subsystems.qsys.objects.QSYSRemoteObject;
import com.ibm.etools.iseries.subsystems.qsys.objects.QSYSRemoteSourceMember;
import com.ibm.etools.iseries.subsystems.qsys.objects.RemoteObjectContext;
import dburse.utilities.BrowserParameters;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.internal.browser.WorkbenchBrowserSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginFileManager {
    private BrowserParameters browserParameters;
    private static Logger logger;
    private static PluginFileManager pluginFileManager;
    private Vector<BrowserParameters> browserParametersList = new Vector();

    private PluginFileManager() {
    }

    public static synchronized PluginFileManager getInstance() {
        if (pluginFileManager == null) {
            pluginFileManager = new PluginFileManager();
        }
        return pluginFileManager;
    }

    public void setBrowserParameters(RemoteObjectContext remoteObjectContext, String objectType, String library, String file, String member) {
        QSYSObjectSubSystem subSystem = remoteObjectContext.getObjectSubsystem();
        String ipAddress = subSystem.getHostName();
        String connectionName = subSystem.getHostAliasName();
        String userId = subSystem.getUserId();
        String name = member.equals("*FIRST") ? file : member;
        logger.debug((Object)"----------------------------------------------");
        logger.debug((Object)objectType);
        logger.debug((Object)("name            " + name));
        logger.debug((Object)("member          " + member));
        logger.debug((Object)("file            " + file));
        logger.debug((Object)("library         " + library));
        logger.debug((Object)("ip address      " + ipAddress));
        logger.debug((Object)("connection name " + connectionName));
        logger.debug((Object)("userId          " + userId));
        logger.debug((Object)"----------------------------------------------");
        this.browserParameters = new BrowserParameters(connectionName, ipAddress, userId, objectType, library, file, member, name);
        this.browserParametersList.add(this.browserParameters);
    }

    public void runSelectedDataFile(QSYSRemoteDataFile selectedFile) {
        String member = "*FIRST";
        String file = selectedFile.getName();
        String library = selectedFile.getLibrary();
        RemoteObjectContext remoteObjectContext = (RemoteObjectContext)selectedFile.getRemoteObjectContext();
        this.setBrowserParameters(remoteObjectContext, "Physicals", library, file, member);
    }

    public void runSelectedDDMFile(QSYSRemoteDDMFile selectedFile) {
        String member = "*FIRST";
        String file = selectedFile.getName();
        String library = selectedFile.getLibrary();
        RemoteObjectContext remoteObjectContext = (RemoteObjectContext)selectedFile.getRemoteObjectContext();
        this.setBrowserParameters(remoteObjectContext, "DDM", library, file, member);
    }

    public void runSelectedLogicalFile(QSYSRemoteLogicalFile selectedFile) {
        String member = "*FIRST";
        String file = selectedFile.getName();
        String library = selectedFile.getLibrary();
        RemoteObjectContext remoteObjectContext = (RemoteObjectContext)selectedFile.getRemoteObjectContext();
        this.setBrowserParameters(remoteObjectContext, "Logicals", library, file, member);
    }

    public void runSelectedObjectFile(QSYSRemoteObject selectedFile, String objectType) {
        String member = "*FIRST";
        String file = selectedFile.getName();
        String library = selectedFile.getLibrary();
        RemoteObjectContext remoteObjectContext = (RemoteObjectContext)selectedFile.getRemoteObjectContext();
        this.setBrowserParameters(remoteObjectContext, objectType, library, file, member);
    }

    public void runSelectedRemoteSourceMember(QSYSRemoteSourceMember selectedFile) {
        String member = selectedFile.getName();
        String file = selectedFile.getFile();
        String library = "*LIBL";
        String type = selectedFile.getType().equals("PF") ? "Physicals" : "Logicals";
        RemoteObjectContext remoteObjectContext = (RemoteObjectContext)selectedFile.getRemoteObjectContext();
        this.setBrowserParameters(remoteObjectContext, type, library, file, member);
    }

    public void runSelectedRemoteDataMember(QSYSRemoteMember selectedFile) {
        String member = selectedFile.getName();
        String file = selectedFile.getFile();
        String library = selectedFile.getLibrary();
        RemoteObjectContext remoteObjectContext = (RemoteObjectContext)selectedFile.getRemoteObjectContext();
        this.setBrowserParameters(remoteObjectContext, "Physicals", library, file, member);
    }

    protected Shell getShell() {
        return SystemBasePlugin.getActiveWorkbenchShell();
    }

    public BrowserParameters getBrowserParameters() {
        return this.browserParameters;
    }

    public void initializeLogger() {
        logger = Logger.getLogger((String)PluginFileManager.class.getName());
    }

    public Vector<BrowserParameters> getBrowserParametersList() {
        return this.browserParametersList;
    }

    public String getDbuRdiProperty(String propertyName) {
        String propertyValue = "";
        String dbuRdiClientPath = "C:" + File.separatorChar + "ProData" + File.separatorChar + "DBU RDi Client";
        try {
            String dbuRdiPropFilePath = String.valueOf(dbuRdiClientPath) + File.separatorChar + "rdi.properties";
            File dbuRdiPropFile = new File(dbuRdiPropFilePath);
            if (dbuRdiPropFile.exists() && dbuRdiPropFile.canRead()) {
                Properties properties = new Properties();
                properties.load(new FileInputStream(dbuRdiPropFile));
                propertyValue = properties.getProperty(propertyName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        logger.debug((Object)(String.valueOf(propertyName) + ": " + propertyValue));
        return propertyValue;
    }

    public String getServerIpAddress() {
        String ipAddress = this.getDbuRdiProperty("server_ip");
        if (ipAddress == null) {
            ipAddress = "localhost";
        }
        logger.debug((Object)("ip address: " + ipAddress));
        return ipAddress;
    }

    public String getAjaxTimeout() {
        String timeout = this.getDbuRdiProperty("ajax_timeout");
        if (timeout == null) {
            timeout = "";
        }
        logger.debug((Object)("ajax timeout: " + timeout));
        return timeout;
    }

    public boolean isValidIpAddress(String ipAddress) {
        if (ipAddress != null && ipAddress.trim().length() > 0) {
            if (ipAddress.toLowerCase().equals("localhost")) {
                logger.debug((Object)"found localhost");
                return true;
            }
            if (ipAddress.matches("^(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$")) {
                String[] groups = ipAddress.split("\\.");
                int i = 0;
                while (i <= 3) {
                    String segment = groups[i];
                    if (segment == null || segment.length() <= 0) {
                        logger.debug((Object)"no ip address segments found");
                        return false;
                    }
                    int value = 0;
                    try {
                        value = Integer.parseInt(segment);
                    }
                    catch (NumberFormatException numberFormatException) {
                        logger.debug((Object)("number format exception for " + segment));
                        return false;
                    }
                    if (value > 255) {
                        logger.debug((Object)("segment value error: " + value));
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        }
        logger.debug((Object)("invalid ip address " + ipAddress));
        return false;
    }

    public String getOutputFromURL(String urlStr) {
        String output = "";
        try {
            URL urlTemp = new URL(urlStr);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(urlTemp.openStream(), "UTF-8"));
            String line = "";
            while ((line = bufferedReader.readLine()) != null) {
                output = String.valueOf(output) + line;
            }
        }
        catch (MalformedURLException mfe) {
            logger.error((Object)mfe.getMessage());
        }
        catch (IOException ioe) {
            logger.error((Object)ioe.getMessage());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        logger.debug((Object)("output from URL " + urlStr + "  " + output));
        return output;
    }

    private String getFeatureVersion() {
        String version = (String)Platform.getBundle((String)"com.prodata.dbuwebplugin.rse.menu").getHeaders().get("Bundle-Version");
        return version.replaceAll("(\\d+\\.\\d+\\.\\d+).*", "$1");
    }

    private boolean getSaveNewServerIp(String reason) {
        File dbuRdiPropFile = new File("C:" + File.separatorChar + "ProData" + File.separatorChar + "DBU RDi Client" + File.separatorChar + "rdi.properties");
        if (reason.equals("new_version") && dbuRdiPropFile.exists()) {
            try {
                String ipAddress = this.getDbuRdiProperty("server_ip");
                PrintStream fileStream = new PrintStream(dbuRdiPropFile);
                fileStream.println("[ProData]");
                fileStream.println("server_ip=" + ipAddress);
                fileStream.println("version=" + this.getFeatureVersion());
                fileStream.close();
                return true;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                logger.error((Object)("Error copying resource file: " + e.getMessage() + " " + e.getLocalizedMessage()));
            }
        } else {
            InputDialog dialog;
            String message = "Enter the IP address of the machine running DBU RDi Server:";
            if (reason.equals("invalid_ip")) {
                message = "The provided DBU RDi Server IP is not valid. Please enter a valid IP address:";
            }
            if ((dialog = new InputDialog(this.getShell(), "Set DBU RDi Server IP Address", message, "", null)).open() == 0) {
                String ipAddress = dialog.getValue();
                if (!this.isValidIpAddress(ipAddress)) {
                    return this.getSaveNewServerIp("invalid_ip");
                }
                try {
                    PrintStream fileStream = new PrintStream(dbuRdiPropFile);
                    fileStream.println("[ProData]");
                    fileStream.println("server_ip=" + ipAddress);
                    fileStream.println("version=" + this.getFeatureVersion());
                    fileStream.close();
                    return true;
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    logger.error((Object)("Error copying resource file: " + e.getMessage() + " " + e.getLocalizedMessage()));
                }
            }
        }
        return false;
    }

    private void copyFile(InputStream source, Path dest) {
        try {
            if (dest.toFile().exists()) {
                Files.delete(dest);
            }
            Files.copy(source, dest, new CopyOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error((Object)("Error copying resource file: " + e.getMessage() + " " + e.getLocalizedMessage()));
        }
    }

    private boolean copyHelpFiles(String dbuRdiClientHelpPath) {
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            InputStream sourceFile = classLoader.getResourceAsStream("resources/help/index.html");
            Path destPath = Paths.get(String.valueOf(dbuRdiClientHelpPath) + File.separatorChar + "index.html", new String[0]);
            this.copyFile(sourceFile, destPath);
            sourceFile = classLoader.getResourceAsStream("resources/help/main.css");
            destPath = Paths.get(String.valueOf(dbuRdiClientHelpPath) + File.separatorChar + "main.css", new String[0]);
            this.copyFile(sourceFile, destPath);
            sourceFile = classLoader.getResourceAsStream("resources/help/DBURDi-UserManual.pdf");
            destPath = Paths.get(String.valueOf(dbuRdiClientHelpPath) + File.separatorChar + "DBURDi-UserManual.pdf", new String[0]);
            this.copyFile(sourceFile, destPath);
            sourceFile = classLoader.getResourceAsStream("resources/help/warning.png");
            destPath = Paths.get(String.valueOf(dbuRdiClientHelpPath) + File.separatorChar + "warning.png", new String[0]);
            this.copyFile(sourceFile, destPath);
            sourceFile = classLoader.getResourceAsStream("resources/help/dbu.png");
            destPath = Paths.get(String.valueOf(dbuRdiClientHelpPath) + File.separatorChar + "dbu.png", new String[0]);
            this.copyFile(sourceFile, destPath);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean dbuRdiResourcesUnpacked() {
        boolean newVersion;
        File dbuRdiHelpDir;
        String dbuRdiClientHelpPath;
        block8: {
            File dbuRdiPropFile;
            block7: {
                block6: {
                    String dbuRdiClientPath = "C:" + File.separatorChar + "ProData" + File.separatorChar + "DBU RDi Client";
                    String dbuRdiPropPath = String.valueOf(dbuRdiClientPath) + File.separatorChar + "rdi.properties";
                    dbuRdiPropFile = new File(dbuRdiPropPath);
                    dbuRdiClientHelpPath = String.valueOf(dbuRdiClientPath) + File.separatorChar + "help";
                    dbuRdiHelpDir = new File(dbuRdiClientHelpPath);
                    newVersion = dbuRdiPropFile.exists() ? !this.getDbuRdiProperty("version").equals(this.getFeatureVersion()) : true;
                    if (dbuRdiHelpDir.exists() || dbuRdiHelpDir.mkdirs()) break block6;
                    MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)("Could not create DBU RDi Client directory: C:" + File.separatorChar + "ProData" + File.separatorChar + "DBU RDi Client. Please adjust permissions or create this directory manually."));
                    return false;
                }
                if (!newVersion || this.getSaveNewServerIp("new_version")) break block7;
                return false;
            }
            if (!dbuRdiPropFile.exists() || this.isValidIpAddress(this.getDbuRdiProperty("server_ip")) || this.getSaveNewServerIp("invalid_ip")) break block8;
            return false;
        }
        try {
            if ((newVersion || dbuRdiHelpDir.listFiles().length == 0) && !this.copyHelpFiles(dbuRdiClientHelpPath)) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)("Resources error: " + e.getMessage() + " " + e.getLocalizedMessage()));
        }
        return true;
    }

    private String getDisplayMode() {
        String displayMode = "";
        String userName = System.getProperty("user.name");
        String dbuRdiClientPath = "C:" + File.separatorChar + "Program Files" + File.separatorChar + "ProData" + File.separatorChar + "DBU RDi Client";
        File dbuRdiClientDir = new File(dbuRdiClientPath);
        if (dbuRdiClientDir.exists() && dbuRdiClientDir.canRead()) {
            try {
                String pluginFileName = String.valueOf(dbuRdiClientPath) + File.separatorChar + userName + File.separatorChar + "rdi.properties";
                File pluginFile = new File(pluginFileName);
                if (pluginFile.exists() && pluginFile.canRead()) {
                    Properties properties = new Properties();
                    properties.load(new FileInputStream(pluginFile));
                    displayMode = properties.getProperty("display");
                    if (displayMode == null) {
                        displayMode = "";
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        logger.debug((Object)("display mode " + displayMode));
        return displayMode;
    }

    public void loadBrowser(String file, String member) {
        String completeFile = file;
        if (!WorkbenchBrowserSupport.getInstance().isInternalWebBrowserAvailable()) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"No internal browser detected. Please install a compatible browser on your computer and try again.");
            return;
        }
        if (!member.trim().equals("")) {
            completeFile = String.valueOf(file) + "/" + member + ".mbr";
        }
        String tabName = String.valueOf(this.browserParameters.getConnectionName()) + "/" + this.browserParameters.getSelectedLibrary() + "/" + completeFile;
        long startDate = new Date().getTime();
        String systemLibrary = String.valueOf(this.browserParameters.getConnectionName()) + "/" + this.browserParameters.getSelectedLibrary();
        String filePath = String.valueOf(systemLibrary) + "/" + completeFile;
        String connectionName = this.browserParameters.getConnectionName();
        String cleanedConnectionName = connectionName.replaceAll("[^a-zA-Z0-9.]", "");
        String windowsUserName = System.getProperty("user.name");
        logger.debug((Object)"----------------------------------------------------------------");
        logger.debug((Object)("connection name:   " + connectionName + "  cleaned: " + cleanedConnectionName));
        logger.debug((Object)("as400 ip address:  " + this.browserParameters.getAS400IpAddress()));
        logger.debug((Object)("user name:         " + this.browserParameters.getUserName()));
        logger.debug((Object)("windows user name: " + windowsUserName));
        logger.debug((Object)("selected type:     " + this.browserParameters.getSelectedType()));
        logger.debug((Object)("selected library:  " + this.browserParameters.getSelectedLibrary()));
        logger.debug((Object)("selected file:     " + this.browserParameters.getSelectedFile()));
        logger.debug((Object)("selected member:   " + this.browserParameters.getSelectedMember()));
        logger.debug((Object)("edit object name:  " + this.browserParameters.getEditObjectName()));
        logger.debug((Object)"----------------------------------------------------------------");
        boolean resourcesUnpacked = this.dbuRdiResourcesUnpacked();
        long endDate = new Date().getTime();
        logger.debug((Object)("found the user rdi properties file: " + resourcesUnpacked + "  " + (endDate - startDate) + "  " + new Date()));
        if (!resourcesUnpacked) {
            String message = "An error occurred while unpacking DBU RDi Plugin resources. Please uninstall the plugin and try again.\n\nContact ProData Customer Support if the issue persists: 800-228-6318 (Option 2).";
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)message);
            logger.error((Object)"Missing rdi.properties file");
            return;
        }
        startDate = new Date().getTime();
        String dbuRdiServerIp = this.getServerIpAddress();
        String ajaxTimeout = this.getAjaxTimeout();
        String as400IpAddress = this.browserParameters.getAS400IpAddress();
        String userName = this.browserParameters.getUserName().toLowerCase();
        startDate = new Date().getTime();
        String port = this.getTomcatPort();
        MessageDialog dialog = this.getCustomMessageDialog("Checking DBU RDi Server connection (" + dbuRdiServerIp + "). Please wait...\n\n(This test may take 30-60 seconds)");
        try {
            String pluginURL = "http://" + dbuRdiServerIp + ":" + port + "/DBU/";
            String queryString = "?userName=" + userName + "&eoSystem=" + URLEncoder.encode(cleanedConnectionName, "UTF-8") + "&eoLibrary=" + URLEncoder.encode(this.browserParameters.getSelectedLibrary(), "UTF-8") + "&eoType=" + URLEncoder.encode(this.browserParameters.getSelectedType(), "UTF-8") + "&eoFile=" + URLEncoder.encode(this.browserParameters.getSelectedFile(), "UTF-8") + "&eoMember=" + URLEncoder.encode(this.browserParameters.getSelectedMember(), "UTF-8") + "&eoName=" + URLEncoder.encode(this.browserParameters.getEditObjectName(), "UTF-8") + "&as400Ip=" + as400IpAddress;
            if (ajaxTimeout != "") {
                queryString = String.valueOf(queryString) + "&ajaxTimeout=" + ajaxTimeout;
            }
            logger.debug((Object)("plugin URL " + pluginURL + queryString + "  " + new Date()));
            String displayMode = this.getDisplayMode();
            int style = 40;
            if (displayMode.equals("debug")) {
                style = 42;
            }
            String browserId = tabName;
            String testConn = this.getOutputFromURL(String.valueOf(pluginURL) + "testConn/" + queryString);
            logger.debug((Object)("Test connection: " + testConn));
            IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
            if (!testConn.equals("CONNECTED")) {
                dialog.close();
                if (testConn.equals("PROCESSING")) {
                    MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Another file is currently being processed. Please wait for the previous file to finish loading and try again.");
                } else if (testConn.equals("NOUSER")) {
                    MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)("User " + userName + " not found. Please try again."));
                } else {
                    dialog = new MessageDialog(null, "Verify DBU RDi Server IP Address", null, "Could not connect to the DBU RDi Server.\n\nIs the following IP correct? Current IP: " + dbuRdiServerIp, 3, new String[]{"Yes", "No"}, 0);
                    if (dialog.open() == 1) {
                        if (this.getSaveNewServerIp("connection_failed")) {
                            dialog.close();
                            this.loadBrowser(file, member);
                        } else {
                            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Error updating DBU RDi Server IP address.\n\nPlease try again or contact ProData Tech Support for assistance: 800-228-6318");
                        }
                    } else {
                        String helpFileURL = "file:///C:/ProData/DBU RDi Client/help/index.html#ip=" + dbuRdiServerIp;
                        IWebBrowser browser = browserSupport.createBrowser(style, browserId, "DBU RDi - Server Connection Error", filePath);
                        browser.openURL(new URL(helpFileURL));
                        logger.debug((Object)"Web Server is down.");
                    }
                    dialog.close();
                }
                return;
            }
            dialog.close();
            dialog = this.getCustomMessageDialog(tabName);
            IWebBrowser browser = browserSupport.createBrowser(style, null, null, systemLibrary);
            browser.openURL(new URL(String.valueOf(pluginURL) + queryString));
            if (dialog != null) {
                try {
                    dialog.close();
                }
                catch (Exception exception) {
                    logger.debug((Object)"Exception caught here.");
                }
            }
        }
        catch (PartInitException pie) {
            if (dialog != null) {
                dialog.close();
            }
            logger.error((Object)pie.getMessage());
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)("PartInitException \n" + pie.getMessage()));
        }
        catch (MalformedURLException mfe) {
            if (dialog != null) {
                dialog.close();
            }
            logger.error((Object)mfe.getMessage());
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)mfe.getMessage());
        }
        catch (Exception e) {
            if (dialog != null) {
                dialog.close();
            }
            e.printStackTrace();
            logger.error((Object)e.getMessage());
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)e.getLocalizedMessage());
        }
    }

    private MessageDialog getCustomMessageDialog(String message) {
        MessageDialog dialog = new MessageDialog(this.getShell(), "Status", null, message, 2, new String[]{"Close"}, 0){

            protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
                return null;
            }

            protected boolean canHandleShellCloseEvent() {
                return false;
            }

            protected void setShellStyle(int arg0) {
                super.setShellStyle(32);
            }
        };
        dialog.setBlockOnOpen(false);
        dialog.open();
        return dialog;
    }

    public String getTomcatPort() {
        return "8081";
    }
}

