/*
 * Decompiled with CFR 0.152.
 */
package dburse.utilities;

import com.ibm.etools.iseries.subsystems.qsys.objects.QSYSObjectSubSystem;
import com.ibm.etools.iseries.subsystems.qsys.objects.QSYSRemoteDDMFile;
import com.ibm.etools.iseries.subsystems.qsys.objects.QSYSRemoteDataFile;
import com.ibm.etools.iseries.subsystems.qsys.objects.QSYSRemoteLogicalFile;
import com.ibm.etools.iseries.subsystems.qsys.objects.QSYSRemoteMember;
import com.ibm.etools.iseries.subsystems.qsys.objects.QSYSRemoteObject;
import com.ibm.etools.iseries.subsystems.qsys.objects.RemoteObjectContext;
import dburse.utilities.BrowserParameters;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Date;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.browser.WorkbenchBrowserSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginFileManager {
    private BrowserParameters browserParameters;
    private static Logger logger;
    private static PluginFileManager pluginFileManager;
    private Vector<BrowserParameters> browserParametersList = new Vector();

    private PluginFileManager() {
    }

    public static synchronized PluginFileManager getInstance() {
        if (pluginFileManager == null) {
            pluginFileManager = new PluginFileManager();
        }
        return pluginFileManager;
    }

    public void setBrowserParameters(RemoteObjectContext remoteObjectContext, String objectType, String library, String file, String member) {
        QSYSObjectSubSystem subSystem = remoteObjectContext.getObjectSubsystem();
        String ipAddress = subSystem.getHostName();
        String connectionName = subSystem.getHostAliasName();
        String userId = subSystem.getUserId();
        String name = member.equals("*FIRST") ? file : member;
        logger.debug((Object)"----------------------------------------------");
        logger.debug((Object)objectType);
        logger.debug((Object)("name            " + name));
        logger.debug((Object)("member          " + member));
        logger.debug((Object)("file            " + file));
        logger.debug((Object)("library         " + library));
        logger.debug((Object)("ip address      " + ipAddress));
        logger.debug((Object)("connection name " + connectionName));
        logger.debug((Object)("userId          " + userId));
        logger.debug((Object)"----------------------------------------------");
        this.browserParameters = new BrowserParameters(connectionName, ipAddress, userId, objectType, library, file, member, name);
        this.browserParametersList.add(this.browserParameters);
    }

    public void runSelectedDataFile(QSYSRemoteDataFile selectedFile) {
        String member = "*FIRST";
        String file = selectedFile.getName();
        String library = selectedFile.getLibrary();
        RemoteObjectContext remoteObjectContext = (RemoteObjectContext)selectedFile.getRemoteObjectContext();
        this.setBrowserParameters(remoteObjectContext, "Physicals", library, file, member);
    }

    public void runSelectedDDMFile(QSYSRemoteDDMFile selectedFile) {
        String member = "*FIRST";
        String file = selectedFile.getName();
        String library = selectedFile.getLibrary();
        RemoteObjectContext remoteObjectContext = (RemoteObjectContext)selectedFile.getRemoteObjectContext();
        this.setBrowserParameters(remoteObjectContext, "DDM", library, file, member);
    }

    public void runSelectedLogicalFile(QSYSRemoteLogicalFile selectedFile) {
        String member = "*FIRST";
        String file = selectedFile.getName();
        String library = selectedFile.getLibrary();
        RemoteObjectContext remoteObjectContext = (RemoteObjectContext)selectedFile.getRemoteObjectContext();
        this.setBrowserParameters(remoteObjectContext, "Logicals", library, file, member);
    }

    public void runSelectedObjectFile(QSYSRemoteObject selectedFile, String objectType) {
        String member = "*FIRST";
        String file = selectedFile.getName();
        String library = selectedFile.getLibrary();
        RemoteObjectContext remoteObjectContext = (RemoteObjectContext)selectedFile.getRemoteObjectContext();
        this.setBrowserParameters(remoteObjectContext, objectType, library, file, member);
    }

    public void runSelectedRemoteDataMember(QSYSRemoteMember selectedFile) {
        String member = selectedFile.getName();
        String file = selectedFile.getFile();
        String library = selectedFile.getLibrary();
        RemoteObjectContext remoteObjectContext = (RemoteObjectContext)selectedFile.getRemoteObjectContext();
        this.setBrowserParameters(remoteObjectContext, "Physicals", library, file, member);
    }

    protected Shell getShell() {
        return SystemBasePlugin.getActiveWorkbenchShell();
    }

    public BrowserParameters getBrowserParameters() {
        return this.browserParameters;
    }

    public void initializeLogger() {
        logger = Logger.getLogger((String)PluginFileManager.class.getName());
    }

    public Vector<BrowserParameters> getBrowserParametersList() {
        return this.browserParametersList;
    }

    public String getProperty(String propertyName) {
        String propertyValue = "";
        String userHome = System.getProperty("user.home");
        String userProDataDir = String.valueOf(userHome) + File.separatorChar + "ProData";
        File proDataDir = new File(userProDataDir);
        if (proDataDir.exists() && proDataDir.canRead()) {
            try {
                String pluginFileName = String.valueOf(userProDataDir) + File.separatorChar + "rdi.properties";
                File pluginFile = new File(pluginFileName);
                if (pluginFile.exists() && pluginFile.canRead()) {
                    Properties properties = new Properties();
                    properties.load(new FileInputStream(pluginFile));
                    propertyValue = properties.getProperty(propertyName);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        logger.debug((Object)(String.valueOf(propertyName) + ": " + propertyValue));
        return propertyValue;
    }

    public String getTomcatIpAddress() {
        String ipAddress = this.getProperty("ip_address");
        if (ipAddress == null) {
            ipAddress = "localhost";
        }
        logger.debug((Object)("ip address: " + ipAddress));
        return ipAddress;
    }

    public String getAjaxTimeout() {
        String timeout = this.getProperty("ajax_timeout");
        if (timeout == null) {
            timeout = "30000";
        }
        logger.debug((Object)("ajax timeout: " + timeout));
        return timeout;
    }

    public boolean isValidIpAddress(String ipAddress) {
        if (ipAddress != null && ipAddress.trim().length() > 0) {
            if (ipAddress.toLowerCase().equals("localhost")) {
                logger.debug((Object)"found localhost");
                return true;
            }
            if (ipAddress.matches("^(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$")) {
                String[] groups = ipAddress.split("\\.");
                int i = 0;
                while (i <= 3) {
                    String segment = groups[i];
                    if (segment == null || segment.length() <= 0) {
                        logger.debug((Object)"no ip address segments found");
                        return false;
                    }
                    int value = 0;
                    try {
                        value = Integer.parseInt(segment);
                    }
                    catch (NumberFormatException numberFormatException) {
                        logger.debug((Object)("number format exception for " + segment));
                        return false;
                    }
                    if (value > 255) {
                        logger.debug((Object)("segment value error: " + value));
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        }
        logger.debug((Object)("invalid ip address " + ipAddress));
        return false;
    }

    public String getOutputFromURL(String urlStr) {
        String output = "";
        try {
            URL urlTemp = new URL(urlStr);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(urlTemp.openStream(), "UTF-8"));
            String line = "";
            while ((line = bufferedReader.readLine()) != null) {
                output = String.valueOf(output) + line;
            }
        }
        catch (MalformedURLException mfe) {
            logger.error((Object)mfe.getMessage());
        }
        catch (IOException ioe) {
            logger.error((Object)ioe.getMessage());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        logger.debug((Object)("output from URL " + urlStr + "  " + output));
        return output;
    }

    private boolean foundRdiPropertiesFile() {
        String userHome = System.getProperty("user.home");
        String userProDataDir = String.valueOf(userHome) + File.separatorChar + "ProData" + File.separatorChar + "rdi.properties";
        File proDataDir = new File(userProDataDir);
        return proDataDir.exists() && proDataDir.canRead();
    }

    private String getDisplayMode() {
        String displayMode = "";
        String userHome = System.getProperty("user.home");
        String userProDataDir = String.valueOf(userHome) + File.separatorChar + "ProData";
        File proDataDir = new File(userProDataDir);
        if (proDataDir.exists() && proDataDir.canRead()) {
            try {
                String pluginFileName = String.valueOf(userProDataDir) + File.separatorChar + "rdi.properties";
                File pluginFile = new File(pluginFileName);
                if (pluginFile.exists() && pluginFile.canRead()) {
                    Properties properties = new Properties();
                    properties.load(new FileInputStream(pluginFile));
                    displayMode = properties.getProperty("display");
                    if (displayMode == null) {
                        displayMode = "";
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        logger.debug((Object)("display mode " + displayMode));
        return displayMode;
    }

    public void loadBrowser(String file, String member) {
        if (!WorkbenchBrowserSupport.getInstance().isInternalWebBrowserAvailable()) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"No internal browser detected. Please install a compatible browser on your computer and try again.");
            return;
        }
        if (!member.trim().equals("")) {
            file = String.valueOf(file) + "/" + member + ".mbr";
        }
        String tabName = String.valueOf(this.browserParameters.getConnectionName()) + "/" + this.browserParameters.getSelectedLibrary() + "/" + file;
        MessageDialog dialog = this.getCustomMessageDialog(tabName);
        long startDate = new Date().getTime();
        String tabTitle = "DBU-" + file;
        String filePath = String.valueOf(this.browserParameters.getConnectionName()) + "/" + this.browserParameters.getSelectedLibrary() + "/" + file;
        String connectionName = this.browserParameters.getConnectionName();
        String cleanedConnectionName = connectionName.replaceAll("[^a-zA-Z0-9.]", "");
        String windowsUserName = System.getProperty("user.name");
        logger.debug((Object)"----------------------------------------------------------------");
        logger.debug((Object)("connection name:   " + connectionName + "  cleaned: " + cleanedConnectionName));
        logger.debug((Object)("as400 ip address:  " + this.browserParameters.getAS400IpAddress()));
        logger.debug((Object)("ajax timeout:      " + this.getAjaxTimeout()));
        logger.debug((Object)("user name:         " + this.browserParameters.getUserName()));
        logger.debug((Object)("windows user name: " + windowsUserName));
        logger.debug((Object)("selected type:     " + this.browserParameters.getSelectedType()));
        logger.debug((Object)("selected library:  " + this.browserParameters.getSelectedLibrary()));
        logger.debug((Object)("selected file:     " + this.browserParameters.getSelectedFile()));
        logger.debug((Object)("selected member:   " + this.browserParameters.getSelectedMember()));
        logger.debug((Object)("edit object name:  " + this.browserParameters.getEditObjectName()));
        logger.debug((Object)"----------------------------------------------------------------");
        boolean foundUserRdiPropertiesFile = this.foundRdiPropertiesFile();
        long endDate = new Date().getTime();
        logger.debug((Object)("found the user rdi properties file: " + foundUserRdiPropertiesFile + "  " + (endDate - startDate) + "  " + new Date()));
        if (!foundUserRdiPropertiesFile) {
            String message = "Missing properties file for " + windowsUserName + ".\n\rPlease re-install DBU RDi Client and try again.";
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)message);
            logger.error((Object)("Missing rdi.properties file for " + windowsUserName));
            dialog.close();
            return;
        }
        startDate = new Date().getTime();
        String tomcatIpAddress = this.getTomcatIpAddress();
        String ajaxTimeout = this.getAjaxTimeout();
        if (!this.isValidIpAddress(tomcatIpAddress)) {
            String message = "Invalid IP address (" + tomcatIpAddress + ") in the properties file for " + windowsUserName + ".\n\rPlease re-install DBU RDi Client and try again.";
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)message);
            dialog.close();
            return;
        }
        String as400IpAddress = this.browserParameters.getAS400IpAddress();
        String userName = this.browserParameters.getUserName().toLowerCase();
        startDate = new Date().getTime();
        String port = this.getTomcatPort();
        try {
            String pluginURL = "http://" + tomcatIpAddress + ":" + port + "/DBU/?user=" + userName + "&systemName=" + URLEncoder.encode(cleanedConnectionName, "UTF-8") + "&libName=" + URLEncoder.encode(this.browserParameters.getSelectedLibrary(), "UTF-8") + "&typeName=" + URLEncoder.encode(this.browserParameters.getSelectedType(), "UTF-8") + "&eoFile=" + URLEncoder.encode(this.browserParameters.getSelectedFile(), "UTF-8") + "&eoMember=" + URLEncoder.encode(this.browserParameters.getSelectedMember(), "UTF-8") + "&eoName=" + URLEncoder.encode(this.browserParameters.getEditObjectName(), "UTF-8") + "&fileWithExt=" + URLEncoder.encode(file, "UTF-8") + "&as400ip=" + as400IpAddress + "&ajaxTimeout=" + ajaxTimeout;
            logger.debug((Object)("plugin URL " + pluginURL + "  " + new Date()));
            String displayMode = this.getDisplayMode();
            int style = 40;
            if (displayMode.equals("debug")) {
                style = 42;
            }
            String browserId = tabName;
            String testConn = this.getOutputFromURL(String.valueOf(pluginURL) + "&connTest=true");
            logger.debug((Object)("Test connection: " + testConn));
            if (!testConn.equals("CONNECTED")) {
                if (testConn.equals("PROCESSING")) {
                    MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Another file is currently being processed. Please wait for the previous file to finish loading and try again.");
                } else {
                    String helpFileURL = "file:///C:/Users/" + userName + "/ProData/help/index.html";
                    WorkbenchBrowserSupport.getInstance().createBrowser(style, browserId, "ProData DBU RDi Help", filePath).openURL(new URL(helpFileURL));
                    logger.debug((Object)"Web Server is down.");
                }
                dialog.close();
                return;
            }
            WorkbenchBrowserSupport.getInstance().createBrowser(style, browserId, tabTitle, filePath).openURL(new URL(pluginURL));
            if (dialog != null) {
                try {
                    dialog.close();
                }
                catch (Exception exception) {
                    logger.debug((Object)"Exception caught here.");
                }
            }
        }
        catch (PartInitException pie) {
            if (dialog != null) {
                dialog.close();
            }
            logger.error((Object)pie.getMessage());
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)("PartInitException \n" + pie.getMessage()));
        }
        catch (MalformedURLException mfe) {
            if (dialog != null) {
                dialog.close();
            }
            logger.error((Object)mfe.getMessage());
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)mfe.getMessage());
        }
        catch (Exception e) {
            if (dialog != null) {
                dialog.close();
            }
            e.printStackTrace();
            logger.error((Object)e.getMessage());
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)e.getLocalizedMessage());
        }
    }

    private MessageDialog getCustomMessageDialog(String tabName) {
        MessageDialog dialog = new MessageDialog(this.getShell(), "Information", null, "Loading " + tabName, 2, new String[]{"Close"}, 0){

            protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
                return null;
            }

            protected boolean canHandleShellCloseEvent() {
                return false;
            }

            protected void setShellStyle(int arg0) {
                super.setShellStyle(32);
            }
        };
        dialog.setBlockOnOpen(false);
        dialog.open();
        return dialog;
    }

    public String getTomcatPort() {
        return "8081";
    }
}

